# Contributing to XOOPS CMS Project

We welcome your contributions to [XOOPS CMS Project](https://xoops.org) on [GitHub](https://github.com/XOOPS)!

We use a [fork and pull](https://www.atlassian.com/git/tutorials/comparing-workflows/forking-workflow) workflow on GitHub that allows anyone to contribute changes. You don't need any special permissions, just a GitHub account. This is a lot easier to manage if you follow these basic steps:

- [Fork the XoopsCore repository](https://help.github.com/articles/fork-a-repo/) and work from that
- Create a [topic branch](http://git-scm.com/book/en/v2/Git-Branching-Branching-Workflows#Topic-Branches) for your changes, and keep all changes on that branch focused on a specific topic.
- Please consider updating the [unit tests](https://phpunit.de/getting-started.html) to include and verify your changes
- All PHP code is expected to conform to [PSR-2](http://www.php-fig.org/psr/psr-2) standards
- Once your changes are complete, commit your topic branch to your fork and create a [pull request (PR)](https://help.github.com/articles/using-pull-requests/)
- Be prepared to discuss your changes. We will review and test each PR, and may need clarification or changes. Once we have completed the review, you changes will be incorporated into XOOPS.

# Licensing

By contributing code you agree to license your contribution under the [GNU General Public License, Version 2 or any later version.](https://www.gnu.org/licenses/gpl-2.0.html)
